package ibase.servlet;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import ibase.entity.Employee;
import ibase.entity.Report;
import ibase.entity.TodaysPlan;
import ibase.util.EmployeeDao;
import ibase.utility.BaseLogger;

@WebServlet("/planview")
public class PlanViewServlet extends HttpServlet {

	private static final long serialVersionUID = 1L;
	List<Employee> empList = new ArrayList<>();
	List<TodaysPlan> todaysPlanList = new ArrayList<>();
	List<Report> feedbackList = new ArrayList<>();
	EmployeeDao empDao;

	protected void doGet(HttpServletRequest request, HttpServletResponse response) {

		BaseLogger.log("0", null, null, "calling /planview Servlet......");
		response.setContentType("application/json");
		try {
			String action = request.getParameter("action");
			BaseLogger.log("0", null, null, "calling /planview Servlet action=["+action+"]");
			// JSONArray jsonArray = new JSONArray();
			if (action.equalsIgnoreCase("empList")) {
				empDao = new EmployeeDao();
				empList.addAll(empDao.getEmpList());
				BaseLogger.log("0", null, null, "Employee List=" + empList);
				JSONArray jsonArray = new JSONArray(empList.stream().map(emp -> {
					JSONObject jsonObject = new JSONObject();
					try {
						jsonObject.put("empcode", emp.getEmpcode());
						jsonObject.put("name", emp.getName());
					} catch (JSONException e) {
						BaseLogger.log("0", null, null, "Get Employee List Error =" + e.getMessage());
						e.printStackTrace();
					}
					return jsonObject;
				}).collect(Collectors.toList()));
				String jsonString = jsonArray.toString();
				BaseLogger.log("0", null, null, "Employee List json =" + jsonString);
				PrintWriter writer = response.getWriter();
				writer.print(jsonString);
			} else if (action.equalsIgnoreCase("plan")) {
				todaysPlanList.addAll(empDao.getTodysPlan());
				BaseLogger.log("0", null, null, "Todays Plan List=" + todaysPlanList);
				JSONArray jsonArray = new JSONArray(todaysPlanList.stream().map(plan -> {
					JSONObject jsonObject = new JSONObject();
					try {
						jsonObject.put("name", plan.getName());
						jsonObject.put("date", plan.getDate());
						jsonObject.put("requestid", plan.getRequestid());
						jsonObject.put("description", plan.getDescription());
						jsonObject.put("actiondtl", plan.getActiondtl());
						jsonObject.put("time", plan.getTime());
					} catch (JSONException e) {
						BaseLogger.log("0", null, null, "Get Todays Plan List Error =" + e.getMessage());
						e.printStackTrace();
					}
					return jsonObject;
				}).collect(Collectors.toList()));
				String jsonString = jsonArray.toString();
				BaseLogger.log("0", null, null, "todays planlist List json =" + jsonString);
				PrintWriter writer = response.getWriter();
				writer.print(jsonString);
			} else if (action.equalsIgnoreCase("feedback")) {
				empDao = new EmployeeDao();
				feedbackList.addAll(empDao.getYesterdayFeedback());
				BaseLogger.log("0", null, null, "Feedback List=" + feedbackList);
				JSONArray jsonArray = new JSONArray(
						feedbackList.stream().map(feedback->{
							JSONObject jsonObject = new JSONObject();
							try {
								jsonObject.put("person", feedback.getPerson());
								jsonObject.put("requestId", feedback.getRequestId());
								jsonObject.put("date", feedback.getDate());
								jsonObject.put("description", feedback.getDescription());
								jsonObject.put("actiondtl", feedback.getActiondtl());
								jsonObject.put("stdtime", feedback.getStdtime());
								jsonObject.put("timespend", feedback.getTimespend());
							}catch(JSONException e) {
								BaseLogger.log("0", null, null, "Get feedback List Error =" + e.getMessage());
								e.printStackTrace();
							}
							return jsonObject;
						}).collect(Collectors.toList()));
				String jsonString = jsonArray.toString();
				BaseLogger.log("0", null, null, "feedback List json =" + jsonString);
				PrintWriter writer = response.getWriter();
				writer.print(jsonString);

			}

			

			

			// planList.addAll(empDao.getTodysPlan());
			//request.setAttribute("empList", empList);

			//request.setAttribute("feedbackList", feedbackList);

			//response.setContentType("application/json");

			// RequestDispatcher dispatcher =
			// request.getRequestDispatcher("/ibase/webitm/jsp/workManager/planview.jsp");

			// dispatcher.forward(request, response);
			// response.sendRedirect("/ibase/webitm/jsp/workManager/planview.jsp");
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
